import React from 'react';
import PropTypes from 'prop-types';
import PaginationButton from './PaginationButton';

const PAGINATION_SIZE = 7;

const SimplePagination = ({ activePage, pageCount, onActivePageChange }) => {
  const pageButtons = [];

  if (pageCount > 1) {
    /* eslint-disable no-param-reassign */
    activePage = Math.max(1, Math.min(activePage, pageCount));
    /* eslint-enable */

    let startPage = 0;
    let endPage = 0;

    if (PAGINATION_SIZE < pageCount) {
      /* eslint-disable no-mixed-operators */
      startPage = activePage - Math.floor(PAGINATION_SIZE / 2);
      startPage = Math.max(Math.min(startPage, pageCount - PAGINATION_SIZE + 1), 1);
      endPage = startPage + PAGINATION_SIZE - 1;
      /* eslint-enable */
    } else {
      startPage = 1;
      endPage = pageCount;
    }

    pageButtons.push((
      <PaginationButton
        key={-1}
        disabled={activePage === 1}
        onClick={() => onActivePageChange(1)}
      >
        {React.createElement('span', {}, '\xAB')}
      </PaginationButton>
    ));

    if (startPage > 1) {
      pageButtons.push((<PaginationButton key={0} disabled>...</PaginationButton>));
    }

    for (let i = startPage; i <= endPage; ++i) {
      pageButtons.push((
        <PaginationButton
          key={i}
          active={i === activePage}
          onClick={() => onActivePageChange(i)}
        >
          {i}
        </PaginationButton>
      ));
    }

    if (endPage < pageCount) {
      pageButtons.push((<PaginationButton key={endPage + 1} disabled>...</PaginationButton>));
    }

    pageButtons.push((
      <PaginationButton
        key={endPage + 2}
        disabled={activePage === pageCount}
        onClick={() => onActivePageChange(pageCount)}
      >
        {React.createElement('span', {}, '\xBB')}
      </PaginationButton>
    ));
  }

  return (
    <div className="pagination">
      {pageButtons}
    </div>
  );
};

SimplePagination.propTypes = {
  activePage: PropTypes.number.isRequired,
  pageCount: PropTypes.number.isRequired,
  onActivePageChange: PropTypes.func.isRequired,
};

export default SimplePagination;
