import React from 'react';
import PropTypes from 'prop-types';

const Panel = ({ title, type, children }) => (
  <div className={`panel panel-${type}`}>
    <div className="panel-heading">{title}</div>
    <div className="panel-body">
      {children}
    </div>
  </div>
);

Panel.propTypes = {
  title: PropTypes.string.isRequired,
  children: PropTypes.node.isRequired,
  type: PropTypes.oneOf([
    'default',
    'primary',
    'success',
    'info',
    'warning',
    'danger',
  ]),
};

Panel.defaultProps = {
  type: 'default',
};

export default Panel;
