import React from 'react';
import PropTypes from 'prop-types';
import isEmpty from 'lodash/isEmpty';
import entries from 'lodash/entries';

function wrapAsLink(href) {
  return <a href={href}>Preview link</a>;
}

function wrapAsAlert(text) {
  return <div className="alert alert-danger">{text}</div>;
}

export function makeOldUiParamSelectors(params, labelsMap) {
  const paramNames = params.map((p) => p.name);

  const selectorsArray = entries(labelsMap)
    .filter((e) => e[0] !== 'project')
    .filter((e) => paramNames.indexOf(e[0]) >= 0)
    .map((e) => {
      const name = e[0];
      const value = e[1];
      return `${name}=${encodeURIComponent(value)}`;
    });

  return selectorsArray.join('&');
}

const PreviewLink = ({
  type, projectId, itemId, params, sensorsPage,
}) => {
  if (isEmpty(params)) {
    return wrapAsLink(`/?project=${projectId}&${type}=${itemId}`);
  }

  if (isEmpty(sensorsPage)) {
    return <div>Loading...</div>;
  }

  const sensors = sensorsPage.result;

  if (sensors.length > 0) {
    const selectors = makeOldUiParamSelectors(params, sensors[0].labels);
    return wrapAsLink(`/?project=${projectId}&${selectors}&${type}=${itemId}`);
  }

  return wrapAsAlert(`Failed to construct preview link, because no metric matched with ${type} parameters.`);
};

PreviewLink.propTypes = {
  type: PropTypes.string.isRequired,
  projectId: PropTypes.string.isRequired,
  itemId: PropTypes.string.isRequired,
  params: PropTypes.array.isRequired,
  sensorsPage: PropTypes.object.isRequired,
};

export default PreviewLink;
