import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import handleTextEditorKeyDown from './utils';

import './style.css';

class ProtoTextEditor extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { text: props.value };
  }

  componentDidUpdate(prevProps) {
    if (this.props.value !== prevProps.value && this.state.text !== prevProps.value) {
      this.setState({ text: this.props.value });
    }
  }

  handleKeyDown = (event) => {
    handleTextEditorKeyDown(event, this._areaEl, (text) => {
      this.setState({ text });
      this.props.onChange(text);
    });
  };

  handleChange = (event) => {
    const text = event.target.value;
    this.setState({ text });
    this.props.onChange(text);
  };

  render() {
    const {
      name, value, placeholder, cols, rows,
    } = this.props;

    return (
      <textarea
        id={this.id}
        name={name}
        className="form-control solomon-proto-text-editor"
        placeholder={placeholder}
        onKeyDown={this.handleKeyDown}
        onChange={this.handleChange}
        value={value}
        cols={cols}
        rows={rows}
        ref={(el) => { this._areaEl = el; }}
      />
    );
  }
}

ProtoTextEditor.propTypes = {
  name: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  placeholder: PropTypes.string,
  value: PropTypes.string,
  cols: PropTypes.number,
  rows: PropTypes.number,
};

ProtoTextEditor.defaultProps = {
  value: '',
  placeholder: '',
  cols: 0,
  rows: 0,
};

export default ProtoTextEditor;
