import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';
import CopyButton from '../CopyButton/CopyButton';

class ShortLinkModal extends PureComponent {
  render() {
    return (
      <ReactModal
        className="modal-dialog"
        contentLabel="Modal"
        isOpen={this.props.isOpen}
        onRequestClose={this.props.onCancel}
      >
        <div className="modal-content">
          <div className="modal-header">
            <button type="button" className="close" onClick={this.props.onCancel}>
              <span>&times;</span>
            </button>
            <h4 className="modal-title">Copy short link</h4>
          </div>
          <div className="modal-body">
            <div className="form">
              <div className="form-group">
                <label htmlFor="shortLinkInput">Link</label>
                <table>
                  <tbody>
                    <tr>
                      <td style={{ width: '100%' }}>
                        <input
                          id="shortLinkInput"
                          className="form-control"
                          value={this.props.link}
                          readOnly
                        />
                      </td>
                      <td style={{ paddingLeft: '5px' }}>
                        <CopyButton value={this.props.link} container={this} />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </ReactModal>
    );
  }
}

ShortLinkModal.propTypes = {
  link: PropTypes.string.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default ShortLinkModal;
