import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class RadioButtons extends PureComponent {
  onChoiceClick = (event) => {
    event.preventDefault();
    this.props.onSelect(event.currentTarget.name);
  };

  render() {
    const {
      choices, selected, size, primary,
    } = this.props;
    let { labels } = this.props;

    if (labels.length === 0) {
      labels = choices;
    }

    const activeBtnClassName = primary ? 'btn btn-primary' : 'btn btn-default active';

    const buttons = choices.map((c, i) => {
      let className = 'btn btn-default';

      if (c === selected) {
        className = activeBtnClassName;
      }

      return (
        <button
          key={c}
          name={c}
          type="button"
          className={className}
          onClick={this.onChoiceClick}
        >
          {labels[i]}
        </button>
      );
    });

    const sizeClass = size ? ` btn-group-${size}` : '';

    return (
      <div className={`btn-group${sizeClass}`}>
        {buttons}
      </div>
    );
  }
}

RadioButtons.propTypes = {
  choices: PropTypes.arrayOf(PropTypes.string).isRequired,
  labels: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.element])),
  selected: PropTypes.string.isRequired,
  onSelect: PropTypes.func.isRequired,
  size: PropTypes.string,
  primary: PropTypes.bool,
};

RadioButtons.defaultProps = {
  labels: [],
  size: '',
  primary: false,
};

export default RadioButtons;
