import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import './style.css';

const OVERHANG_SIZE = 16;

class ShowMore extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { maxHeight: props.initialHeight };
  }

  componentDidMount() {
    if (this.calculateHeight() <= this.props.initialHeight) {
      // eslint-disable-next-line react/no-did-mount-set-state
      this.setState({ hideReadMore: true });
    }
  }

  onToggle = () => {
    const { initialHeight } = this.props;
    const { maxHeight } = this.state;

    if (maxHeight !== initialHeight) {
      this.setState({ maxHeight: initialHeight });
      return;
    }

    const height = this.calculateHeight();

    this.setState({ maxHeight: height });
  };

  calculateHeight() {
    const children = [...this.container.children];
    let height = 0;
    children.forEach((child) => { height += child.offsetHeight; });
    return height;
  }

  render() {
    const { children, initialHeight } = this.props;
    const { maxHeight, hideReadMore } = this.state;
    const open = maxHeight !== initialHeight;

    return (
      <>
        <div
          className="readmore"
          style={{
            maxHeight: open ? maxHeight : maxHeight - OVERHANG_SIZE,
          }}
          ref={(el) => { this.container = el; }}
        >
          {children}
          {hideReadMore ? null : (
            <div
              className="readmore__overhang"
              style={{
                opacity: open ? 0 : 1,
                height: `${OVERHANG_SIZE}px`,
              }}
            />
          )}
        </div>
        {hideReadMore
          ? null
          // eslint-disable-next-line jsx-a11y/interactive-supports-focus
          : (<a role="button" onClick={this.onToggle}>{open ? 'Show less...' : 'Show more...'}</a>)}
      </>
    );
  }
}

ShowMore.propTypes = {
  initialHeight: PropTypes.number,
  children: PropTypes.oneOf([
    PropTypes.node,
    PropTypes.arrayOf(PropTypes.node),
    PropTypes.string,
  ]).isRequired,
};

ShowMore.defaultProps = {
  initialHeight: 200,
};

export default ShowMore;
