import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';

class ConfirmDeletionModal extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { dontAskAnymore: false };
  }

  onConfirm = (event) => {
    this.props.onConfirm(event, this.state.dontAskAnymore);
  };

  onDontAskAnymoreChange = (event) => {
    this.setState({ dontAskAnymore: event.target.checked });
  };

  onCancel = (event) => {
    this.props.onCancel(event);
  };

  render() {
    const { isOpen, showDontAskAnymore } = this.props;

    return (
      <ReactModal
        className="modal-dialog"
        contentLabel="Modal"
        isOpen={isOpen}
        onRequestClose={this.onCancel}
      >
        <div className="modal-content">
          <div className="modal-header">
            <button type="button" className="close" onClick={this.onCancel}>
              <span>&times;</span>
            </button>
            <h4 className="modal-title">Confirm deletion</h4>
          </div>
          <div className="modal-body">
            <p>
              Are you sure you want to delete it? You
              {' '}
              <b>cannot</b>
              {' '}
              invert this action.
            </p>
            {showDontAskAnymore && (
              <p>
                <div className="form-group">
                  <div className="checkbox">
                    <label htmlFor="dontAskAnymore">
                      <input
                        type="checkbox"
                        id="dontAskAnymore"
                        name="dontAskAnymore"
                        checked={this.state.dontAskAnymore}
                        onChange={this.onDontAskAnymoreChange}
                      />
                      {' '}
                      Don&apos;t ask anymore
                    </label>
                  </div>
                </div>
              </p>
            )}
          </div>
          <div className="modal-footer">
            <button type="button" className="btn btn-default" onClick={this.onCancel}>
              Cancel
            </button>
            <button type="button" className="btn btn-danger" onClick={this.onConfirm}>
              Delete
            </button>
          </div>
        </div>
      </ReactModal>
    );
  }
}

ConfirmDeletionModal.propTypes = {
  isOpen: PropTypes.bool.isRequired,
  showDontAskAnymore: PropTypes.bool,
  onConfirm: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

ConfirmDeletionModal.defaultProps = {
  showDontAskAnymore: false,
};

export default ConfirmDeletionModal;
