/* eslint-disable jsx-a11y/no-noninteractive-element-interactions */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import BackLink from '../BackLink';
import ConfirmDeletionModal from './ConfirmDeletionModal';
import './style.css';

class ShowActions extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { dropdownShown: false, modalShown: false };
  }

  onShowDropdown = (event) => {
    event.preventDefault();
    this.setState({ dropdownShown: !this.state.dropdownShown });
  };

  onHideDropdown = (event) => {
    event.preventDefault();
    this.setState({ dropdownShown: false });
  };

  onShowConfirmModal = (event) => {
    event.preventDefault();
    this.setState({ dropdownShown: false, modalShown: true });
  };

  onCancelModal = (event) => {
    event.preventDefault();
    this.setState({ modalShown: false });
  };

  onConfirmDeletion = (event) => {
    this.setState({ modalShown: false });
    this.props.onDelete(event);
  };

  render() {
    const {
      editPath, duplicatePath, onDeactivate, onActivate, isActive,
      canEdit, canDuplicate, canChangeState, canDelete,
      canMute, mutePath, editHref,
    } = this.props;

    if (!canEdit && !canChangeState && !canDelete) {
      return null;
    }

    let changeStateTitle;
    let changeStateAction;
    let style = 'warning';

    if (isActive) {
      changeStateTitle = 'Deactivate';
      changeStateAction = onDeactivate;
    } else {
      changeStateTitle = 'Activate';
      changeStateAction = onActivate;
    }

    const dropdownButtons = [];
    let mainButton;

    if (canMute && mutePath) {
      mainButton = (
        <Link
          type="button"
          className="btn btn-warning btn-outline"
          to={mutePath}
        >
          Mute
        </Link>
      );
    } else if (canChangeState) {
      style = isActive ? 'danger' : 'warning';
      mainButton = (
        <button
          type="button"
          className={`btn btn-${style} btn-outline`}
          onClick={changeStateAction}
        >
          {changeStateTitle}
        </button>
      );
    } else if (canDelete) {
      style = 'danger';
      mainButton = (
        <button
          type="button"
          className="btn btn-danger btn-outline"
          onClick={this.onShowConfirmModal}
        >
          Delete
        </button>
      );
    }

    if (canChangeState) {
      dropdownButtons.push((
        <li key="switch" onMouseDown={changeStateAction}>
          <a role="button">
            {changeStateTitle}
          </a>
        </li>
      ));
    }

    if (canDelete) {
      dropdownButtons.push((
        <li key="delete" onMouseDown={this.onShowConfirmModal}>
          <a role="button">
            Delete
          </a>
        </li>
      ));
    }

    const rightButton = (
      <div className={`btn-group dropup${this.state.dropdownShown ? ' open' : ''}`}>
        {mainButton}
        {dropdownButtons.length > 1 && (
          <>
            <button
              type="button"
              className={`btn btn-${style} btn-outline dropdown-toggle`}
              data-toggle="dropdown"
              onClick={this.onShowDropdown}
              onBlur={this.onHideDropdown}
            >
              <span className="caret" />
            </button>
            <ul className="dropdown-menu">
              {dropdownButtons}
            </ul>
          </>
        )}
      </div>
    );

    let editButton = null;

    if (canEdit) {
      editButton = editHref ? (
        <a href={editHref} className="btn btn-outline btn-primary">Edit</a>
      ) : (
        <Link to={editPath} className="btn btn-outline btn-primary">Edit</Link>
      );
    }

    return (
      <div className="row show-actions">
        <hr />
        <div className="col-xs-offset-2 col-xs-10">
          {editButton}
          &nbsp;
          {canEdit && canDuplicate
          && <Link to={duplicatePath} className="btn btn-outline btn-primary">Duplicate</Link>}
          &nbsp;
          <BackLink>Back</BackLink>
          <div className="pull-right">
            {rightButton}
          </div>
        </div>
        <ConfirmDeletionModal
          isOpen={this.state.modalShown}
          onConfirm={this.onConfirmDeletion}
          onCancel={this.onCancelModal}
        />
      </div>
    );
  }
}

ShowActions.propTypes = {
  editPath: PropTypes.string.isRequired,
  editHref: PropTypes.string,
  duplicatePath: PropTypes.string.isRequired,
  onActivate: PropTypes.func,
  onDeactivate: PropTypes.func,
  onDelete: PropTypes.func.isRequired,
  mutePath: PropTypes.string,
  canMute: PropTypes.bool,
  isActive: PropTypes.bool,
  canEdit: PropTypes.bool,
  canDuplicate: PropTypes.bool,
  canChangeState: PropTypes.bool,
  canDelete: PropTypes.bool,
};

ShowActions.defaultProps = {
  canEdit: true,
  canDuplicate: true,
  canChangeState: true,
  editHref: undefined,
  canDelete: true,
  canMute: false,
  isActive: true,
  onActivate: () => {},
  onDeactivate: () => {},
  mutePath: undefined,
};

export default ShowActions;
