import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { ALERT_EVAL_STATUSES } from '../../../pages/alerts/constants';

import './ProjectAlertStats.css';

class ProjectAlertStats extends PureComponent {
  handleLabelClick = (event, status) => {
    event.preventDefault();
    const url = `/admin/projects/${this.props.projectId}/alerts?evalStatus=${status.value}`;
    this.context.router.history.push(url);
  };

  render() {
    const { stats } = this.props;

    const statsLabels = ALERT_EVAL_STATUSES
      .filter((status) => status.statsName !== 'ok')
      .map((status) => {
        const stat = stats[status.statsName] || 0;

        if (!stat) {
          return null;
        }

        return (
          <span
            key={status.value}
            role="button"
            tabIndex={-1}
            className={`label label-${status.style}`}
            onClick={(event) => this.handleLabelClick(event, status)}
          >
            {stat}
          </span>
        );
      })
      .filter(Boolean);

    if (statsLabels.length === 0) {
      return null;
    }

    return (
      <div className="project-alerts-stats">
        {statsLabels}
      </div>
    );
  }
}

ProjectAlertStats.propTypes = {
  projectId: PropTypes.string.isRequired,
  stats: PropTypes.object.isRequired,
};

ProjectAlertStats.contextTypes = {
  router: PropTypes.object.isRequired,
};

export default ProjectAlertStats;
