import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import SidebarMenu from '../SidebarMenu';
import { clearProjectMutesStats, loadProjectMutesStats } from '../../../store/reducers/mutes/projectMutesStats';
// import ProjectMutesStats from './ProjectMutesStats';

class MutesSidebarMenu extends Component {
  componentDidMount() {
    this.runCoro(this.props.projectId);
  }

  componentDidUpdate(prevProps) {
    if (this.props.projectId !== prevProps.projectId) {
      this.clearCoro();
      this.runCoro(this.props.projectId);
    }
  }

  componentWillUnmount() {
    this.props.clearProjectMutesStats();
    this.clearCoro();
  }

  runCoro = (projectId) => {
    try {
      this.props.loadProjectMutesStats(projectId);
    } catch (e) {
      console.error('failed to load project alert stats', e);
    }
    this._coroHandler = window.setTimeout(() => {
      this.runCoro(projectId);
    }, 60000);
  };

  clearCoro = () => {
    if (this._coroHandler != null) {
      window.clearTimeout(this._coroHandler);
    }
  };

  toggleChildren = (event) => {
    event.preventDefault();
    const { onOpenToggle } = this.props;
    if (onOpenToggle) {
      onOpenToggle();
    }
  };

  render() {
    const {
      projectId,
      subMenus,
      opened,
      // projectMutesStats,
    } = this.props;

    let childrenContainer;
    if (subMenus.length > 0) {
      const childrenElements = subMenus
        .map((child) => <SidebarMenu key={child.uuid} menu={child} />);

      if (opened) {
        childrenContainer = (
          <ul className="nav nav-second-level">
            {childrenElements}
          </ul>
        );
      }
    }

    return (
      <li className={opened ? 'active' : ''}>
        <Link to={`/admin/projects/${projectId}/mutes`}>
          <i className="glyphicon glyphicon-volume-off" />
          Mutes
          {/*
          Temporary hidden until figure out how to display stats in most convenient way

          <ProjectMutesStats
            projectId={projectId}
            stats={projectMutesStats || {}}
          /> */}
          {subMenus.length > 0
            && (
            <i
              className="glyphicon arrow"
              onClick={this.toggleChildren}
              role="link"
              tabIndex={-1}
            />
            )}
        </Link>
        {childrenContainer}
      </li>
    );
  }
}

MutesSidebarMenu.propTypes = {
  projectId: PropTypes.string.isRequired,
  subMenus: PropTypes.array.isRequired,
  opened: PropTypes.bool.isRequired,
  onOpenToggle: PropTypes.func.isRequired,
  // projectMutesStats: PropTypes.object.isRequired,
  loadProjectMutesStats: PropTypes.func.isRequired,
  clearProjectMutesStats: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  projectMutesStats: state.projectMutesStats,
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  loadProjectMutesStats,
  clearProjectMutesStats,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(MutesSidebarMenu);
