import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { MUTES_STATUSES } from '../../../pages/mutes/constants';

import './style.css';

class ProjectMutesStats extends PureComponent {
  handleLabelClick = (event, status) => {
    event.preventDefault();
    const url = `/admin/projects/${this.props.projectId}/mutes?status=${status.value}`;
    this.context.router.history.push(url);
  };

  render() {
    const { stats } = this.props;

    const statsLabels = Object.values(MUTES_STATUSES)
      .map((status) => {
        const stat = stats[status.statsName] || 0;

        if (!stat) {
          return null;
        }

        return (
          <span
            key={status.value}
            role="button"
            tabIndex={-1}
            className={`label label-${status.style}`}
            onClick={(event) => this.handleLabelClick(event, status)}
          >
            {stat}
          </span>
        );
      })
      .filter(Boolean);

    if (statsLabels.length === 0) {
      return null;
    }

    return (
      <div className="project-alerts-stats">
        {statsLabels}
      </div>
    );
  }
}

ProjectMutesStats.propTypes = {
  projectId: PropTypes.string.isRequired,
  stats: PropTypes.object.isRequired,
};

ProjectMutesStats.contextTypes = {
  router: PropTypes.object.isRequired,
};

export default ProjectMutesStats;
