import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

const GlobalOrLocalLink = ({ to, isLocal, children }) => {
  if (isLocal) {
    return (<Link to={to}>{children}</Link>);
  }
  return (<a href={to}>{children}</a>);
};

GlobalOrLocalLink.propTypes = {
  to: PropTypes.string.isRequired,
  isLocal: PropTypes.bool.isRequired,
  children: PropTypes.array.isRequired,
};

class SidebarMenu extends Component {
  toggleChildren = (event) => {
    event.preventDefault();
    const { onOpenToggle } = this.props;
    if (onOpenToggle) {
      onOpenToggle();
    }
  };

  render() {
    const { menu, opened } = this.props;

    let childrenContainer;
    if (menu.hasChild()) {
      const childrenElements = menu.children()
        .map((child) => <SidebarMenu key={child.uuid} menu={child} />);

      if (opened) {
        childrenContainer = (
          <ul className="nav nav-second-level">
            {childrenElements}
          </ul>
        );
      }
    }

    const icon = menu.icon()
      ? <i className={`glyphicon glyphicon-${menu.icon()}`} />
      : null;

    return (
      <li className={opened ? 'active' : ''}>
        <GlobalOrLocalLink to={menu.link()} isLocal={menu.isLocal()}>
          {icon}
          {menu.title()}
          {menu.hasChild()
            && (
            <i
              className="glyphicon arrow"
              onClick={this.toggleChildren}
              role="link"
              tabIndex={-1}
            />
            )}
        </GlobalOrLocalLink>
        {childrenContainer}
      </li>
    );
  }
}

SidebarMenu.propTypes = {
  menu: PropTypes.object.isRequired,
  opened: PropTypes.bool,
  onOpenToggle: PropTypes.func,
};

SidebarMenu.defaultProps = {
  opened: false,
  onOpenToggle: null,
};

export default SidebarMenu;
