import React from 'react';
import PropTypes from 'prop-types';
import RadioButtons from '../RadioButtons';

const DURATION_OPTIONS = [
  { value: '1h', title: 'Hour' },
  { value: '1d', title: 'Day' },
  { value: '7d', title: 'Week' },
  { value: '31d', title: 'Month' },
];

const DURATION_VALUES = DURATION_OPTIONS.map((opt) => opt.value);
const DURATION_TITLES = DURATION_OPTIONS.map((opt) => opt.title);

const DashboardTimeSelector = ({ duration, onChange, children }) => (
  <div style={{ marginBottom: '15px' }}>
    <div
      className="btn-toolbar"
      style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}
    >
      <div className="btn-group" style={{ marginRight: '1ch' }}>
        {children}
      </div>
      <div className="btn-group">
        <RadioButtons
          choices={DURATION_VALUES}
          labels={DURATION_TITLES}
          selected={duration}
          onSelect={onChange}
        />
      </div>
    </div>
  </div>
);

DashboardTimeSelector.propTypes = {
  duration: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  children: PropTypes.element,
};

DashboardTimeSelector.defaultProps = {
  children: null,
};

export default DashboardTimeSelector;
