/* eslint-disable no-param-reassign */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import OldDashboard from '../../pages/old/OldDashboardPage/OldDashboard';

class SolomonDash extends Component {
  shouldComponentUpdate(nextProps) {
    return this.props.id !== nextProps.id
      || this.props.duration !== nextProps.duration
      || !isEqual(this.props.rows, nextProps.rows);
  }

  render() {
    const url = `/?dashboard=${this.props.id}&b=${this.props.duration}`;
    const appElement = document.querySelector('#root') || document.body;

    const fixedRows = this.props.rows.map((row) => {
      if (row.items) {
        const newItems = row.items.map((item) => {
          const newItem = { ...item };
          if (!newItem.colspan) {
            newItem.colspan = 1;
          }
          if (!newItem.rowspan) {
            newItem.rowspan = 1;
          }
          if (newItem.url) {
            newItem.rawUrl = newItem.url;
          }
          return newItem;
        });

        return { items: newItems };
      }

      return row;
    });

    const dashboard = {
      rows: fixedRows,
      height: 1,
    };

    return (
      <OldDashboard
        url={url}
        appElement={appElement}
        dashboard={dashboard}
        isLocal={false}
      />
    );
  }
}

SolomonDash.propTypes = {
  id: PropTypes.string.isRequired,
  rows: PropTypes.array.isRequired,
  duration: PropTypes.string.isRequired,
};

export default SolomonDash;
