export function convertColumnsToRows(columns) {
  const newRows = [];

  for (let columnIndex = 0; columnIndex < columns.length; ++columnIndex) {
    const { name, items } = columns[columnIndex];
    items.forEach((item, rowIndex) => {
      const newItem = { ...item };
      newItem.title += ` (${name})`;
      if (newRows.length <= rowIndex) {
        newRows.push({ items: [newItem] });
      } else {
        newRows[rowIndex].items.push(newItem);
      }
    });
  }

  return newRows;
}

export default { convertColumnsToRows };
