import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import './style.css';
import { isPreOrProdIntEnv } from '../../utils/env';

class TableToolbar extends PureComponent {
  componentDidMount() {
    this.filterInput.focus();
  }

  onFilterChange = (event) => {
    event.preventDefault();
    this.props.onFilterChange(event);
  };

  render() {
    const { filter, createNewLink, createNewInMonitoringLink } = this.props;

    let newButton = null;

    if (createNewLink) {
      newButton = (
        <>
          <Link to={createNewLink} className="btn btn-outline btn-success">
            <i className="glyphicon glyphicon-plus" />
            &nbsp;Create New
          </Link>
          {createNewInMonitoringLink && isPreOrProdIntEnv() && (
            <a href={createNewInMonitoringLink} className="btn btn-primary">
              <i className="glyphicon glyphicon-plus" />
              &nbsp;Create in Monitoring
            </a>
          )}
        </>
      );
    }

    return (
      <div className="btn-toolbar table-toolbar">
        <div className="btn-group">{newButton}</div>
        <div className="btn-group">
          <input
            type="text"
            className="form-control"
            placeholder="Type to filter..."
            defaultValue={filter}
            onChange={this.onFilterChange}
            ref={(input) => {
              this.filterInput = input;
            }}
            tabIndex={0}
          />
        </div>
      </div>
    );
  }
}

TableToolbar.propTypes = {
  filter: PropTypes.string,
  createNewLink: PropTypes.string,
  onFilterChange: PropTypes.func.isRequired,
  createNewInMonitoringLink: PropTypes.string,
};

TableToolbar.defaultProps = {
  filter: '',
  createNewLink: '',
  createNewInMonitoringLink: undefined,
};

export default TableToolbar;
