import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class Toggle extends PureComponent {
  onToggle = (event) => {
    event.preventDefault();
    this.props.onToggle(event.target.name === 'on');
  };

  render() {
    const { labels, value } = this.props;
    const onClass = `btn btn-default ${value && 'active'}`;
    const offClass = `btn btn-default ${!value && 'active'}`;

    return (
      <div className="btn-group">
        <button type="button" name="on" className={onClass} onClick={this.onToggle} tabIndex={-1}>
          {labels[0]}
        </button>
        <button type="button" name="off" className={offClass} onClick={this.onToggle} tabIndex={-1}>
          {labels[1]}
        </button>
      </div>
    );
  }
}

Toggle.propTypes = {
  labels: PropTypes.arrayOf(PropTypes.string),
  value: PropTypes.bool.isRequired,
  onToggle: PropTypes.func.isRequired,
};

Toggle.defaultProps = {
  labels: ['On', 'Off'],
};

export default Toggle;
