import React from 'react';
import PropTypes from 'prop-types';

export const ST_PREFIX = 'https://st.yandex-team.ru/';
export const TICKET_ID_RE = /[A-Z]+-\d*$/;

export default function TicketLink({ text }) {
  const ticketIdFromText = text || '';
  const hasTrackerTicketId = TICKET_ID_RE.test(ticketIdFromText);
  const isLink = ticketIdFromText.startsWith('https://') || hasTrackerTicketId;
  const isCustomLinkLink = isLink && !hasTrackerTicketId;
  const ticketId = ticketIdFromText.replace(ST_PREFIX, '');
  const link = isCustomLinkLink ? ticketIdFromText : `${ST_PREFIX}${ticketId}`;
  const ticketBody = isCustomLinkLink ? ticketIdFromText : ticketId;

  return isLink ? (
    <a href={link} rel="noreferrer" target="_blank">{ticketBody}</a>
  ) : ticketBody;
}

TicketLink.propTypes = {
  text: PropTypes.string.isRequired,
};
