import React from 'react';
import PropTypes from 'prop-types';

import Tiles from './Tiles';
import { computeFitSinglestatStyle } from './fitTileUtils';
import { TILE_SHAPE } from './Tile';

const FlexableSinglestat = ({
  tile, width, height, ...props
}) => {
  const tileStyle = computeFitSinglestatStyle(width, height, tile);
  return (<Tiles tiles={[tile]} {...props} tileStyle={tileStyle} />);
};

FlexableSinglestat.propTypes = {
  tile: TILE_SHAPE.isRequired,
  width: PropTypes.number.isRequired,
  height: PropTypes.number.isRequired,
};

export default FlexableSinglestat;
