import React from 'react';
import PropTypes from 'prop-types';

import Tiles from './Tiles';
import { computeFitTileStyle } from './fitTileUtils';
import { TILE_SHAPE } from './Tile';

const FlexableTiles = ({
  tiles, width, height, ...props
}) => {
  const tileStyle = computeFitTileStyle(width, height, tiles);
  return (<Tiles tiles={tiles} {...props} tileStyle={tileStyle} />);
};

FlexableTiles.propTypes = {
  tiles: PropTypes.arrayOf(TILE_SHAPE).isRequired,
  width: PropTypes.number.isRequired,
  height: PropTypes.number.isRequired,
};

export default FlexableTiles;
