import React from 'react';
import PropTypes from 'prop-types';

import FullscreenObserver from './FullscreenObserver';
import Tiles from './Tiles';
import FlexableSinglestat from './FlexableSinglestat';
import { TILE_SHAPE } from './Tile';

const FullscreenFlexableSinglestat = ({ element, tile, fullscreen }) => {
  if (fullscreen) {
    return (
      <FullscreenObserver
        element={element}
        render={(width, height) => (
          <FlexableSinglestat tile={tile} isTargetBlank width={width} height={height} />
        )}
      />
    );
  }

  return (<Tiles tiles={[tile]} isTargetBlank={false} align="left" />);
};

FullscreenFlexableSinglestat.propTypes = {
  tile: TILE_SHAPE.isRequired,
  fullscreen: PropTypes.bool.isRequired,
  element: PropTypes.element,
};

FullscreenFlexableSinglestat.defaultProps = {
  element: null,
};

export default FullscreenFlexableSinglestat;
