import React from 'react';
import PropTypes from 'prop-types';

import FullscreenObserver from './FullscreenObserver';
import Tiles from './Tiles';
import FlexableTiles from './FlexableTiles';

const FullscreenFlexableTiles = ({ element, fullscreen, ...props }) => {
  if (fullscreen) {
    return (
      <FullscreenObserver
        element={element}
        render={(width, height) => (
          <FlexableTiles {...props} isTargetBlank width={width} height={height} />
        )}
      />
    );
  }

  return (<Tiles {...props} isTargetBlank={false} />);
};

FullscreenFlexableTiles.propTypes = {
  fullscreen: PropTypes.bool.isRequired,
  element: PropTypes.element,
};

FullscreenFlexableTiles.defaultProps = {
  element: null,
};

export default FullscreenFlexableTiles;
