import { PureComponent } from 'react';
import PropTypes from 'prop-types';
import debounce from '../../utils/debounce';

function computeSizeState(element) {
  let state;
  if (element) {
    state = { width: element.scrollWidth, height: element.scrollHeight };
  } else {
    state = { width: window.innerWidth, height: window.innerHeight };
  }
  return state;
}

class FullscreenObserver extends PureComponent {
  constructor(props) {
    super(props);
    this.state = computeSizeState(props.element);
  }

  componentDidMount() {
    window.addEventListener('resize', this.handleResizeWindow);
  }

  componentWillUnmount() {
    window.removeEventListener('resize', this.handleResizeWindow);
  }

  handleResizeWindow = debounce(() => {
    const state = computeSizeState(this.props.element);
    this.setState(state);
  }, 200);

  render() {
    return this.props.render(this.state.width, this.state.height);
  }
}

FullscreenObserver.propTypes = {
  render: PropTypes.func.isRequired,
  element: PropTypes.element,
};

FullscreenObserver.defaultProps = {
  element: null,
};

export default FullscreenObserver;
