/* eslint-disable no-mixed-operators */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { Tile, TILE_SHAPE, TILE_STYLE_SHAPE } from './Tile';

class Tiles extends PureComponent {
  render() {
    const {
      tiles, isTargetBlank, tileStyle, align,
    } = this.props;

    const tilesCount = tiles.length;

    if (tilesCount === 0) {
      return (
        <div className="tiles-wrapper">
          No items found
        </div>
      );
    }

    return (
      <div className="tiles-wrapper">
        <ul className={`tiles tiles_${align}-align`}>
          {tiles.map((value, index) => (
            <Tile
              // eslint-disable-next-line react/no-array-index-key
              key={index}
              value={value}
              style={tileStyle}
              isTargetBlank={isTargetBlank}
            />
          ))}
        </ul>
      </div>
    );
  }
}

Tiles.propTypes = {
  tiles: PropTypes.arrayOf(TILE_SHAPE).isRequired,
  isTargetBlank: PropTypes.bool,
  tileStyle: TILE_STYLE_SHAPE,
  align: PropTypes.oneOf(['center', 'left']),
};

Tiles.defaultProps = {
  isTargetBlank: false,
  tileStyle: null,
  align: 'center',
};

export default Tiles;
