import React from 'react';
import PropTypes from 'prop-types';

import TopLevelAlert from './TopLevelAlert';

const resources2020AlertContent = (daysLeft) => (
  <>
    Attention! If your service needs additional resources in 2020, please follow instructions and
    {' '}
    <a href="https://clubs.at.yandex-team.ru/solomon/646">make an order</a>
    .
    <b>
      Only
      {daysLeft}
      {' '}
      days left!
    </b>
  </>
);

const deadlineTs = Date.UTC(2020, 7, 31, 3, 0);

const Resources2020Alert = ({ admin }) => (
  <TopLevelAlert
    id="isResources2020AlertClosed"
    admin={admin}
    type="danger"
    deadline={deadlineTs}
    content={resources2020AlertContent}
  />
);

Resources2020Alert.propTypes = {
  admin: PropTypes.bool.isRequired,
};

export default Resources2020Alert;
