import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

function calculateDaysLeft(deadlineTs) {
  const nowTs = Date.now();
  return Math.ceil((deadlineTs - nowTs) / (24 * 60 * 60 * 1000));
}

function isClosed(id) {
  return window.localStorage.getItem(id) === 'true';
}

function setClosed(id) {
  window.localStorage.setItem(id, 'true');
}

class TopLevelAlert extends PureComponent {
  constructor(props) {
    super(props);
    const { id } = this.props;
    this.state = {
      closed: isClosed(id),
    };
  }

  onCloseClick = () => {
    const { id } = this.props;
    setClosed(id);
    this.setState({ closed: true });
  };

  render() {
    if (this.state.closed) {
      return null;
    }

    const {
      id, admin, type, deadline, content,
    } = this.props;

    let days = 0;
    if (deadline) {
      days = calculateDaysLeft(deadline);
      if (days <= 0) {
        return null;
      }
    }

    let finalContent;
    if (content instanceof Function) {
      finalContent = content(days, deadline, admin);
    } else {
      finalContent = content;
    }

    return (
      <div id={`top_level_alert_${id}`} className={`alert alert-${type} top-level-alert`}>
        <button type="button" className="close" data-dismiss="alert" onClick={this.onCloseClick}>
          <span>
            &times;
          </span>
        </button>
        {finalContent}
      </div>
    );
  }
}

TopLevelAlert.propTypes = {
  id: PropTypes.string.isRequired,
  admin: PropTypes.bool.isRequired,
  type: PropTypes.string.isRequired,
  deadline: PropTypes.number.isRequired,
  content: PropTypes.oneOfType([PropTypes.func, PropTypes.element, PropTypes.array]).isRequired,
};

export default TopLevelAlert;
