/* eslint-disable jsx-a11y/mouse-events-have-key-events */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import StaffCard from 'staff-card';

import './style.css';

class UserName extends PureComponent {
  onHover = (event) => {
    const { login } = this.props;

    if (this.initedFor !== login) {
      const card = new StaffCard(event.currentTarget, login);
      card.onHover();
      this.initedFor = login;
    }
  };

  render() {
    if (!this.props.login) {
      return <span>-</span>;
    }

    return (
      <a
        className="user-name"
        href={`https://staff.yandex-team.ru/${this.props.login}`}
        onMouseOver={this.onHover}
      >
        <span className="user-name__first-letter">{this.props.login[0]}</span>
        {this.props.login.substr(1)}
      </a>
    );
  }
}

UserName.propTypes = {
  login: PropTypes.string.isRequired,
};

export default UserName;
