import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Datalist from '../Datalist';
import fetchStaffData from './staffRequest';
import debounce from '../../utils/debounce';

import './style.css';

class UserSuggest extends PureComponent {
  _loadDataDebounced = debounce((value) => {
    fetchStaffData(value)
      .then((resp) => this.setState({ usersList: resp.result || [] }))
      .catch(() => {});
  }, 100);

  constructor(props) {
    super(props);
    this.state = { value: props.value, usersList: [] };
  }

  componentDidUpdate(prevProps) {
    if (this.props.value !== prevProps.value) {
      this.setState({ value: this.props.value, usersList: [] });
    }
  }

  handleChange = (event) => {
    const { value } = event.target;
    this.setState({ value });
    this.props.onChange(value);
    this._loadDataDebounced(event.target.value);
  };

  render() {
    const { value } = this.state;

    const mappedDatalist = this.state.usersList.map((item) => ({
      value: item.login,
      content: (
        <div className="user-suggest__item">
          <div className="user-suggest__info">
            <div className="user-suggest__name">
              {`${item.name.first.ru} ${item.name.last.ru}, ${item.login}@`}
            </div>
            <div className="user-suggest__desc">
              {item.department_group.name}
            </div>
          </div>
          <div className="user-suggest__avatar">
            <img
              className="user-suggest__userpic" alt="userpic"
              src={`//center.yandex-team.ru/api/v1/user/${item.login}/avatar/100.jpg`}
            />
          </div>
        </div>
      ),
    }));

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter user name..."
        onChange={this.handleChange}
      />
    );
  }
}

UserSuggest.propTypes = {
  value: PropTypes.string,
  onChange: PropTypes.func,
};

UserSuggest.defaultProps = {
  value: '',
  onChange: () => {},
};

export default UserSuggest;
