function fetchStaffUsers(value) {
  if (!value) {
    Promise.resolve([]);
  }

  const [firstPart = '', secondPart = firstPart] = value.split(' ');
  const or = firstPart === secondPart ? 'or' : 'and';
  const _query = `login==regex('^${value}.*') or name.last.ru==regex('(?i)${firstPart}|${secondPart}.*') ${or} name.first.ru==regex('(?i)${firstPart}|${secondPart}.*')`;

  const params = {
    _query,
    'official.is_dismissed': 'false',
    _fields: 'id,login,name,department_group',
    _sort: 'login',
    _limit: 10,
  };

  const url = `//api.staff.yandex-team.ru/v3/persons?${new URLSearchParams(params).toString()}`;

  return fetch(url, { credentials: 'include' })
    .then((result) => {
      if (result.ok) {
        return result.json();
      }

      return Promise.reject(new Error('staff result is not ok'));
    });
}

export default fetchStaffUsers;
