import React from 'react';
import PropTypes from 'prop-types';

const text = 'Viewing YASM data is not fully supported, please explore at your own risk.\n'
  + '    Specifically, there is no dynamic aggregation,\n'
  + '    some labels might be not displayed and some data types might not be displayed correctly.';

const YasmAlert = () => (
  <div className="alert alert-danger">
    {text}
  </div>
);

export const AdminYasmAlert = ({ projectId }) => (projectId.startsWith('yasm_') ? <YasmAlert /> : null);

AdminYasmAlert.propTypes = {
  projectId: PropTypes.string.isRequired,
};

export default YasmAlert;
