import { Component } from 'react';
import PropTypes from 'prop-types';
import { withRouter } from 'react-router';

const counterId = 25721732;

function hit(url) {
  try {
    if (!window.ym) {
      console.error('no ym() found');
      return;
    }
    window.ym(counterId, 'hit', url);
  } catch (e) {
    console.error('failed to hit by url', url, e);
  }
}

class YmHitListener extends Component {
  componentDidMount() {
    hit(window.location.href);
    this.props.history.listen((location, type) => {
      if (type === 'PUSH') {
        const url = window.origin + location.pathname + location.search;
        hit(url);
      }
    });
  }

  render() {
    return null;
  }
}

YmHitListener.propTypes = {
  history: PropTypes.object.isRequired,
};

export default withRouter(YmHitListener);
