import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import HelpButton from './HelpButton';

class FormArea extends PureComponent {
  static lastId = 0;

  static nextUniqId(prefix) {
    FormArea.lastId += 1;
    return prefix + FormArea.lastId;
  }

  constructor(props) {
    super(props);
    this.id = FormArea.nextUniqId(props.name);
  }

  render() {
    const {
      name, label, labelWidth, value, onChange,
      help, extHelp, placeholder, cols, rows, disabled,
    } = this.props;

    const areaEl = (
      <textarea
        id={this.id}
        name={name}
        className="form-control"
        placeholder={placeholder}
        onChange={onChange}
        value={value}
        cols={cols}
        rows={rows}
        style={{ resize: 'vertical' }}
        disabled={disabled}
      />
    );

    return (
      <div className="form-group">
        <label className={`col-sm-${labelWidth} control-label`} htmlFor={this.id}>
          {label}
          {<HelpButton label={label} extHelp={extHelp} />}
        </label>
        <div className={`col-sm-${12 - labelWidth}`}>
          {areaEl}
          {help && (
          <span className="help-block">
            {help}
            .
          </span>
          )}
        </div>
      </div>
    );
  }
}

FormArea.propTypes = {
  name: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  labelWidth: PropTypes.number,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string,
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  extHelp: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  placeholder: PropTypes.string,
  cols: PropTypes.number,
  rows: PropTypes.number,
  disabled: PropTypes.bool,
};

FormArea.defaultProps = {
  value: '',
  labelWidth: 2,
  help: '',
  extHelp: '',
  placeholder: '',
  cols: 0,
  rows: 0,
  disabled: false,
};

export default FormArea;
