import React from 'react';
import PropTypes from 'prop-types';

import BackLink from '../BackLink/index';

const FormButtons = ({
  saveTitle, cancelTitle, onSubmit, onExplain,
}) => (
  <div>
    <hr />
    <div className="form-group">
      <div className="col-xs-offset-2 col-xs-10">
        <button
          type="button"
          className="btn btn-outline btn-primary"
          onClick={onSubmit}
        >
          {saveTitle}
        </button>
        &nbsp;
        {onExplain ? (
          <>
            <button
              type="button"
              className="btn btn-outline btn-info"
              onClick={onExplain}
            >
              Explain
            </button>
            &nbsp;
          </>
        ) : null}
        <BackLink>{cancelTitle}</BackLink>
      </div>
    </div>
  </div>
);

FormButtons.propTypes = {
  saveTitle: PropTypes.string,
  cancelTitle: PropTypes.string,
  onSubmit: PropTypes.func.isRequired,
  onExplain: PropTypes.func,
};

FormButtons.defaultProps = {
  onExplain: undefined,
  saveTitle: 'Save',
  cancelTitle: 'Cancel',
};

export default FormButtons;
