import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class FormCheckbox extends PureComponent {
  static lastId = 0;

  static nextUniqId(prefix) {
    FormCheckbox.lastId += 1;
    return prefix + FormCheckbox.lastId;
  }

  constructor(props) {
    super(props);
    this.id = FormCheckbox.nextUniqId(props.name);
  }

  render() {
    const {
      name, label, value, onChange, help, disabled,
    } = this.props;
    return (
      <div className="form-group">
        <div className="col-sm-offset-2 col-sm-10">
          <div className="checkbox">
            <label htmlFor={this.id}>
              <input
                type="checkbox" disabled={disabled}
                id={this.id} name={name} checked={value} onChange={onChange}
              />
              {' '}
              {label}
            </label>
          </div>
          {help && (
          <span className="help-block">
            {help}
            .
          </span>
          )}
        </div>
      </div>
    );
  }
}

FormCheckbox.propTypes = {
  name: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.bool,
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  disabled: PropTypes.bool,
};

FormCheckbox.defaultProps = {
  value: false,
  disabled: false,
  help: '',
};

export default FormCheckbox;
