/* eslint-disable react/no-string-refs */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import Datalist from '../Datalist/index';

class FormDatalist extends PureComponent {
  static lastId = 0;

  static nextUniqId(prefix) {
    FormDatalist.lastId += 1;
    return prefix + FormDatalist.lastId;
  }

  constructor(props) {
    super(props);
    this.id = FormDatalist.nextUniqId(props.name);
  }

  focus() {
    this.refs.datalist.focus();
  }

  render() {
    const {
      name, label, value, onChange,
      help, placeholder, datalist, disabled,
    } = this.props;

    const filteredDatalist = value ? datalist.filter((item) => item.indexOf(value) >= 0) : datalist;
    const mappedDatalist = filteredDatalist.map((item) => ({ value: item }));

    return (
      <div className="form-group">
        <label className="col-sm-2 control-label" htmlFor={this.id}>
          {label}
        </label>
        <div className="col-sm-10">
          <Datalist
            name={name}
            placeholder={placeholder}
            datalist={mappedDatalist}
            value={value}
            disabled={disabled}
            ref="datalist"
            onChange={onChange}
          />
          {help && (
          <span className="help-block">
            {help}
            .
          </span>
          )}
        </div>
      </div>
    );
  }
}

FormDatalist.propTypes = {
  name: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  datalist: PropTypes.array,
  value: PropTypes.string,
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  placeholder: PropTypes.string,
  disabled: PropTypes.bool,
};

FormDatalist.defaultProps = {
  datalist: [],
  value: '',
  help: '',
  placeholder: '',
  disabled: false,
};

export default FormDatalist;
