import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import HelpButton from './HelpButton';

class FormElement extends PureComponent {
  render() {
    const {
      label, labelWidth, extHelp, help, children,
    } = this.props;

    return (
      <div className="form-group">
        {/* eslint-disable jsx-a11y/label-has-for */}
        <label className={`col-sm-${labelWidth} control-label`}>
          {label}
          &nbsp;
          {<HelpButton label={label} extHelp={extHelp} />}
        </label>
        {/* eslint-enable */}
        <div className={`col-sm-${12 - labelWidth}`}>
          {children}
          {help && (
          <span className="help-block">
            {help}
            .
          </span>
          )}
        </div>
      </div>
    );
  }
}

FormElement.propTypes = {
  label: PropTypes.string.isRequired,
  labelWidth: PropTypes.number,
  extHelp: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  children: PropTypes.node.isRequired,
};

FormElement.defaultProps = {
  labelWidth: 2,
  extHelp: '',
  help: '',
};

export default FormElement;
