import React from 'react';
import PropTypes from 'prop-types';

const FormGroup = ({ title, children, disabled }) => (
  <fieldset disabled={disabled}>
    <legend>{title}</legend>
    {children}
  </fieldset>
);

FormGroup.propTypes = {
  title: PropTypes.string.isRequired,
  children: PropTypes.node.isRequired,
  disabled: PropTypes.bool,
};

FormGroup.defaultProps = {
  disabled: false,
};

export default FormGroup;
