/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import FormElement from './FormElement';

const FormSelect = ({
  name, label, labelWidth, value, defaultValue, options, extHelp, help, onChange, disabled,
}) => (
  <FormElement label={label} labelWidth={labelWidth} extHelp={extHelp} help={help}>
    <select
      name={name}
      disabled={disabled}
      className="form-control"
      value={value || defaultValue}
      onChange={onChange}
    >
      {options.map((option, index) => (
        // eslint-disable-next-line react/no-array-index-key
        <option key={index} value={option.value}>
          {option.title}
        </option>
      ))}
    </select>
  </FormElement>
);

FormSelect.propTypes = {
  name: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  labelWidth: PropTypes.number,
  value: PropTypes.string,
  defaultValue: PropTypes.string,
  options: PropTypes.array.isRequired,
  extHelp: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  onChange: PropTypes.func.isRequired,
  disabled: PropTypes.bool,
};

FormSelect.defaultProps = {
  value: null,
  defaultValue: null,
  labelWidth: 2,
  extHelp: null,
  help: null,
  disabled: false,
};

export default FormSelect;
