import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../Modal';

class HelpButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { isOpen: false };
  }

  handleModalToggle = () => {
    this.setState({ isOpen: !this.state.isOpen });
  };

  render() {
    const { label, extHelp } = this.props;

    if (extHelp) {
      return (
        <span>
          <button type="button" className="btn btn-default btn-xs" onClick={this.handleModalToggle}>?</button>
          <Modal title={label} onCancel={this.handleModalToggle} isOpen={this.state.isOpen}>
            {extHelp}
          </Modal>
        </span>
      );
    }

    return null;
  }
}

HelpButton.propTypes = {
  label: PropTypes.string.isRequired,
  extHelp: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
};

HelpButton.defaultProps = {
  extHelp: null,
};

export default HelpButton;
