import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';

import { PAGE_TITLE } from './utils/titles';
import { tryRestoreLocation } from './utils/sessionStorage';
import { store } from './store';
import App from './App';

import './index.css';

document.title = PAGE_TITLE;

tryRestoreLocation();

ReactDOM.render(
  <Provider store={store}>
    <App />
  </Provider>,
  document.getElementById('root'),
);
