import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { BrowserRouter as Router } from 'react-router-dom';

import astro from './notFound/404.png';
import Auth from '../auth/Auth';
import AdminHeader from '../components/Header/AdminHeader';
import BrowserUtils from '../utils/BrowserUtils';

class AuthenticationErrorPage extends PureComponent {
  onClick = () => {
    Auth.redirectToPassport(true);
  };

  render() {
    const content = (
      <>
        <div>
          Authentication has failed.
          Please, refresh page or go to
          {' '}
          {/* eslint-disable-next-line jsx-a11y/anchor-is-valid */}
          <a role="presentation" style={{ cursor: 'pointer' }} onClick={this.onClick}>passport</a>
          {' '}
          to sign in.
        </div>
        {this.props.tryToReload && (
          <div>
            Try to reload page...
          </div>
        )}
      </>
    );

    if (BrowserUtils.inIframe()) {
      return (
        <div style={{ textAlign: 'center' }}>
          {content}
        </div>
      );
    }

    return (
      <Router>
        <div>
          <AdminHeader />
          <div id="page-wrapper">
            <div className="container">
              <div className="not-found">
                <div className="row">
                  <div className="col-md-6">
                    <h3>Houston, we have a problem.</h3>
                    {content}
                  </div>
                  <div className="col-md-6">
                    <img src={astro} className="not-found__astro" alt="notFound" />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </Router>
    );
  }
}

AuthenticationErrorPage.propTypes = {
  tryToReload: PropTypes.bool.isRequired,
};

export default AuthenticationErrorPage;
