import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import AlertingHealthForm from './AlertingHealthForm';
import PageTitle from '../../components/PageTitle';
import Breadcrumb from '../../components/Breadcrumb/Breadcrumb';
import WarningAlert from '../projects/alerts/WarningAlert';
import UserSettingsForm from './UserSettingsForm';

import { loadUserSettings, updateUserSettings } from '../../store/reducers/others/userSettings';

class PreferencesPage extends PureComponent {
  componentDidMount() {
    this.props.loadUserSettings();
  }

  render() {
    const { loading, data, error } = this.props.userSettingsData;

    if (loading) {
      return <span>Loading...</span>;
    }

    if (error) {
      return <WarningAlert title="Error!" message="Failed to load preferences" />;
    }

    if (!data) {
      return null;
    }

    const settings = data.settings || {};

    return (
      <div>
        <Breadcrumb match={this.props.match} />
        <PageTitle title="Preferences" />
        <div className="col-sm-6">
          <UserSettingsForm settings={settings} onChange={this.props.updateUserSettings} />
          <AlertingHealthForm />
        </div>
      </div>
    );
  }
}

PreferencesPage.propTypes = {
  match: PropTypes.object.isRequired,
  userSettingsData: PropTypes.object.isRequired,
  loadUserSettings: PropTypes.func.isRequired,
  updateUserSettings: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  userSettingsData: state.userSettings,
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  loadUserSettings,
  updateUserSettings,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(PreferencesPage);
