import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import FormCheckbox from '../../components/forms/FormCheckbox';
import FormGroup from '../../components/forms/FormGroup';
import { isPreOrProdIntEnv } from '../../utils/env';

class UserSettingsForm extends PureComponent {
  onBoolChange = (event) => {
    const newSettings = { ...this.props.settings, [event.target.name]: `${event.target.checked}` };
    this.props.onChange(newSettings);
  };

  render() {
    const showAllValuesInSelectors = this.props.settings.showAllValuesInSelectors === 'true';
    const redirectToNewUi = this.props.settings.redirectToNewUi === 'true';

    return (
      <div className="form-horizontal">
        <FormGroup title="User settings">
          <FormCheckbox
            name="showAllValuesInSelectors"
            label="Show all values in selectors by default"
            value={showAllValuesInSelectors}
            onChange={this.onBoolChange}
          />
          {isPreOrProdIntEnv() && (
            <FormCheckbox
              name="redirectToNewUi"
              label="Redirect to new UI"
              value={redirectToNewUi}
              onChange={this.onBoolChange}
            />
          )}
        </FormGroup>
      </div>
    );
  }
}

UserSettingsForm.propTypes = {
  settings: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default UserSettingsForm;
