import React from 'react';
import PropTypes from 'prop-types';
import BackLink from '../../../components/BackLink';

const AlertFormButtons = ({ onSubmit, onExplain }) => (
  <div>
    <hr />
    <div className="form-group">
      <div className="col-xs-offset-2 col-xs-10">
        <button
          type="button"
          className="btn btn-outline btn-primary"
          onClick={onSubmit}
        >
          Save
        </button>
        &nbsp;
        <button
          type="button"
          className="btn btn-outline btn-info"
          onClick={onExplain}
        >
          Explain
        </button>
        &nbsp;
        <BackLink>Cancel</BackLink>
      </div>
    </div>
  </div>
);

AlertFormButtons.propTypes = {
  onSubmit: PropTypes.func.isRequired,
  onExplain: PropTypes.func.isRequired,
};

export default AlertFormButtons;
