import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ChannelRow from './ChannelRow';
import { ALERT_EVAL_STATUS } from '../../constants';

export default class ChannelListEditor extends PureComponent {
  handleChangeChannel = (index, channel) => {
    const newChannels = [...this.props.channels];
    newChannels.splice(index, 1, channel);
    this.props.onChange(newChannels);
  };

  handleDeleteChannel = (index) => {
    const newChannels = [...this.props.channels];
    newChannels.splice(index, 1);
    this.props.onChange(newChannels);
  };

  handleAddChannelClick = () => {
    const newChannels = [...this.props.channels];
    const newChannel = { id: '', config: { notifyAboutStatuses: [...this.props.notifyAboutStatusesDefault], repeatDelaySecs: 0 } };
    newChannels.push(newChannel);
    this.props.onChange(newChannels);
  };

  render() {
    const { projectId, channels } = this.props;

    let table = null;

    if (channels.length > 0) {
      table = (
        <div className="responsive">
          <table className="table table-condensed table-hover table-row-pointer">
            <thead>
              <tr>
                <th>Channel</th>
                <th>Notify about statuses</th>
                <th>Re-notification</th>
                <th />
              </tr>
            </thead>
            <tbody>
              {channels.map((channel, index) => (
                <ChannelRow
                  index={index}
                  // eslint-disable-next-line react/no-array-index-key
                  key={`${channel.id}_${index}`}
                  projectId={projectId}
                  channel={channel}
                  onChange={this.handleChangeChannel}
                  onDelete={this.handleDeleteChannel}
                />
              ))}
            </tbody>
          </table>
        </div>
      );
    }

    return (
      <div>
        {table}
        <div>
          <button type="button" className="btn btn-default" onClick={this.handleAddChannelClick}>
            <i className="glyphicon glyphicon-plus" />
          </button>
        </div>
      </div>
    );
  }
}

ChannelListEditor.propTypes = {
  projectId: PropTypes.string.isRequired,
  channels: PropTypes.array.isRequired,
  notifyAboutStatusesDefault: PropTypes.array,
  onChange: PropTypes.func.isRequired,
};

ChannelListEditor.defaultProps = {
  notifyAboutStatusesDefault: [ALERT_EVAL_STATUS.ALARM.value],
};
