import React from 'react';
import PropTypes from 'prop-types';
import ChannelSuggest from '../ChannelSuggest/ChannelSuggest';
import ExtendedDurationInput from './ExtendedDurationInput';
import AlertEvalStatuses from '../../components/AlertEvalStatuses';

export default class ChannelRow extends React.Component {
  handleIdChange = (id) => {
    const newId = id || '';
    const oldChannel = this.props.channel;
    const newChannel = { ...oldChannel, id: newId };
    this.props.onChange(this.props.index, newChannel);
  };

  handleConfigChange = (configDiff) => {
    const oldChannel = this.props.channel;
    const oldConfig = oldChannel ? (oldChannel.config || {}) : {};
    const newConfig = { ...oldConfig, ...configDiff };
    const newChannel = { ...oldChannel, config: newConfig };
    this.props.onChange(this.props.index, newChannel);
  };

  handleRepeatDelaySecsChange = (repeatDelaySecs) => {
    this.handleConfigChange({ repeatDelaySecs });
  };

  handleNotifyAboutStatusesChange = (notifyAboutStatuses) => {
    this.handleConfigChange({ notifyAboutStatuses });
  };

  handleDeleteClick = () => {
    this.props.onDelete(this.props.index);
  };

  render() {
    const { projectId } = this.props;
    const { channel } = this.props;
    const id = channel.id || '';
    const config = channel.config || {};
    const notifyAboutStatuses = config.notifyAboutStatuses || [];
    const repeatDelaySecs = config.repeatDelaySecs || 0;

    return (
      <tr>
        <td style={{ minWidth: '250px' }}>
          <ChannelSuggest
            projectId={projectId}
            value={id}
            onChange={this.handleIdChange}
            multi={false}
          />
        </td>
        <td>
          <AlertEvalStatuses
            editable
            values={notifyAboutStatuses}
            onChange={this.handleNotifyAboutStatusesChange}
          />
        </td>
        <td>
          <ExtendedDurationInput
            name="repeatedDelaySecs"
            value={repeatDelaySecs}
            onChange={this.handleRepeatDelaySecsChange}
          />
        </td>
        <td className="actions">
          <button type="button" onClick={this.handleDeleteClick}>
            <i className="glyphicon glyphicon-remove" />
          </button>
        </td>
      </tr>
    );
  }
}

ChannelRow.propTypes = {
  index: PropTypes.number.isRequired,
  projectId: PropTypes.string.isRequired,
  channel: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
  onDelete: PropTypes.func.isRequired,
};
