import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class ChannelOption extends PureComponent {
  handleMouseDown = (event) => {
    event.preventDefault();
    event.stopPropagation();
    this.props.onSelect(this.props.option, event);
  };

  handleMouseEnter = (event) => {
    this.props.onFocus(this.props.option, event);
  };

  handleMouseMove = (event) => {
    if (this.props.isFocused) {
      return;
    }
    this.props.onFocus(this.props.option, event);
  };

  render() {
    const { option, className } = this.props;

    return (
      // eslint-disable-next-line jsx-a11y/interactive-supports-focus
      <div
        className={className}
        onMouseDown={this.handleMouseDown}
        onMouseEnter={this.handleMouseEnter}
        onMouseMove={this.handleMouseMove}
        role="button"
        title={option.name}
      >
        {!option.id ? option.value : null}
        {option.name}
        <br />
        <small>{option.id}</small>
      </div>
    );
  }
}

ChannelOption.propTypes = {
  className: PropTypes.string.isRequired,
  isFocused: PropTypes.bool.isRequired,
  onFocus: PropTypes.func.isRequired,
  onSelect: PropTypes.func.isRequired,
  option: PropTypes.object.isRequired,
};

export default ChannelOption;
