import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Select from 'react-select';
import { fetchChannels } from '../../../../api/channels';
import ChannelOption from './ChannelOption';

class ChannelSuggest extends PureComponent {
  static filterOptions() {
    return true;
  }

  handleChange = (result) => {
    if (!result) {
      this.props.onChange(null);
    } else if (this.props.multi) {
      const newValues = result.map((option) => option.value);
      this.props.onChange(newValues);
    } else {
      this.props.onChange(result.value);
    }
  };

  handleValueClick = (option) => {
    window.open(`/admin/projects/${this.props.projectId}/channels/${option.value}/edit`);
  };

  loadOptions = (input, callback) => {
    fetchChannels(this.props.projectId, { filterByName: input })
      .then((result) => {
        const items = result.items || [];

        const options = items.map((item) => ({
          value: item.id,
          name: item.name,
          id: item.id,
        }));
        callback(null, { options, complete: true });

        return Promise.resolve();
      });
  };

  render() {
    const { values, value, multi } = this.props;

    if (multi) {
      const options = values.map((v) => ({ label: v, value: v }));

      return (
        <Select.AsyncCreatable
          multi
          value={options}
          optionComponent={ChannelOption}
          loadOptions={this.loadOptions}
          filterOption={ChannelSuggest.filterOptions}
          onChange={this.handleChange}
          onValueClick={this.handleValueClick}
          placeholder="Channels..."
        />
      );
    }

    const option = { label: value, value };

    return (
      <Select.AsyncCreatable
        value={option}
        optionComponent={ChannelOption}
        loadOptions={this.loadOptions}
        filterOption={ChannelSuggest.filterOptions}
        onChange={this.handleChange}
        onValueClick={this.handleValueClick}
        placeholder="Channel..."
      />
    );
  }
}

ChannelSuggest.propTypes = {
  projectId: PropTypes.string.isRequired,
  values: PropTypes.array,
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  multi: PropTypes.bool,
};

ChannelSuggest.defaultProps = {
  values: [],
  value: '',
  multi: true,
};

export default ChannelSuggest;
