import React from 'react';
import PropTypes from 'prop-types';

import { Link } from 'react-router-dom';
import isEmpty from 'lodash/isEmpty';

import MuteStatus from '../../mutes/components/MuteStatus';
import Panel from '../../../components/Panel';

const MutesBlock = ({ projectId, evalState }) => {
  if (isEmpty(evalState?.muteStatus?.affectingMutes)) {
    return null;
  }

  return (
    <Panel title="Alert mutes">
      <div className="table-responsive">
        <table className="table table-condensed">
          <thead>
            <tr>
              <th>Mute ID</th>
              <th>State</th>
            </tr>
          </thead>
          <tbody>
            {evalState.muteStatus.affectingMutes.map((mute) => (
              <tr>
                <td>
                  <Link to={`/admin/projects/${projectId}/mutes/${mute.muteId}`}>
                    {mute.muteId}
                  </Link>
                </td>
                <td>
                  <MuteStatus mute={mute} />
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </Panel>
  );
};

MutesBlock.propTypes = {
  evalState: PropTypes.object.isRequired,
  projectId: PropTypes.string.isRequired,
};

export default MutesBlock;
